<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class OneTimePurchaseDetails extends \Google\Model
{
  /**
   * @var string
   */
  public $offerId;
  protected $preorderDetailsType = PreorderDetails::class;
  protected $preorderDetailsDataType = '';
  /**
   * @var string
   */
  public $purchaseOptionId;
  /**
   * @var int
   */
  public $quantity;
  protected $rentalDetailsType = RentalDetails::class;
  protected $rentalDetailsDataType = '';

  /**
   * @param string
   */
  public function setOfferId($offerId)
  {
    $this->offerId = $offerId;
  }
  /**
   * @return string
   */
  public function getOfferId()
  {
    return $this->offerId;
  }
  /**
   * @param PreorderDetails
   */
  public function setPreorderDetails(PreorderDetails $preorderDetails)
  {
    $this->preorderDetails = $preorderDetails;
  }
  /**
   * @return PreorderDetails
   */
  public function getPreorderDetails()
  {
    return $this->preorderDetails;
  }
  /**
   * @param string
   */
  public function setPurchaseOptionId($purchaseOptionId)
  {
    $this->purchaseOptionId = $purchaseOptionId;
  }
  /**
   * @return string
   */
  public function getPurchaseOptionId()
  {
    return $this->purchaseOptionId;
  }
  /**
   * @param int
   */
  public function setQuantity($quantity)
  {
    $this->quantity = $quantity;
  }
  /**
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }
  /**
   * @param RentalDetails
   */
  public function setRentalDetails(RentalDetails $rentalDetails)
  {
    $this->rentalDetails = $rentalDetails;
  }
  /**
   * @return RentalDetails
   */
  public function getRentalDetails()
  {
    return $this->rentalDetails;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OneTimePurchaseDetails::class, 'Google_Service_AndroidPublisher_OneTimePurchaseDetails');
